#########################################################################
# file: Bootstrap-limiting-distr.r
# Example 6.2: R-code for CI of threshold r's  and pdfs
# Created by Dong Li. Adjusted for US Unemployment logistic data 
#                                                     (250 observations!)  
##########################################################################
USUNEMP=read.table("C:/../USUNEMP_logist_n250.dat")[,1]   
gr=USUNEMP
res=read.table("C:/.../resUSUNEMP.dat")[,1] 

sd(res)

A=matrix(numeric(245*7),245,7) # number of gr = 252 - 7 = 245, max length = 7
A[,1]<-res                     # Note the matrix A is not used, apart from B and D
A[,2]<-1
for (i in 3:7){                # maximum number of AR lag = 5
A[,i]<-gr[(8-i):(252-i)]
}
B=D=A                          # 245 * 7 matrices

####################################################################
r=-3.1438825654      # 1st  threshold value
R=-2.972862976       # 2nd

beta1=c(-0.550796063070607,1.63291104432278,-0.811344410655920,0,0,0 )
beta2=c(1.46905669628177,2.15714743080980, -1.10976185616710,-0.379701962562308, 
        0.569073793176358, 0.245334183573505)
beta3=c(-0.0520122836038581,1.46894946616663,-0.451371801687259,0.0717711452721233, 
        -0.283428626105888, 0.177078833312862)
B[,7]<-rep(r,245) # Replicates r 245 times 
Tr=B

D[,6]=rep(R,245)  # replicates R
TR=D
#######################################################################
#####  Bootstrap the limiting distribution of n(r-r_0)    #############
#######################################################################
plot(density(gr))
abline(v=c(r,R))

h=density(gr)$bw             #  h = 0.08519733
labda1 =mean(exp(-(gr-r)^2/(2*h^2)))/(h*sqrt(2*pi)) 
                             # Mean of the estimates of \pi(r_{0i})
labda2 =mean(exp(-(gr-R)^2/(2*h^2)))/(h*sqrt(2*pi))

abline(h=c(labda1,labda2))
pir=labda1
piR=labda2
#######################################################################
###                 Calculate the minimizer (for r)
#######################################################################

CPPMr<-function(T,Tr){
beta1=c(-0.550796063070607,1.63291104432278,-0.811344410655920,0,0,0)	
beta2=c(1.46905669628177,2.15714743080980,-1.10976185616710,
        -0.379701962562308,0.569073793176358,0.245334183573505)

pir=0.7592194       # Intensity parameter of the Poisson process labda1
N1<-rpois(1,pir*T)  # Left-side process of the original with T=100
U1<-runif(N1,-T,0)
Ar=Tr[runif(N1,1,245),][,2:7]%*%(beta1-beta2)
Y1=Ar^2+2*Tr[runif(N1,1,243),][,1]*Ar   ## Jump distribution

N2<-rpois(1,pir*T)  ## Right-side process of the original
U2<-runif(N2,0,T)
Br=Tr[runif(N2,1,245),][,2:7]%*%(beta1-beta2)
Y2=Br^2-2*Tr[runif(N2,1,245),][,1]*Br

t<-seq(-T,T,by=T/1000)
y<-sapply(t,function(x)  sum((U1>x)*Y1)*(x<0)+sum((U2<x)*Y2)*(x>=0))
return(t[which.min(y)])  ### Minimizer
}
#########################################################################
###                 Calculate the minimizer (for R)
#########################################################################
CPPMR<-function(T,TR){
beta2=c(1.46905669628177,2.15714743080980,-1.10976185616710,-0.379701962562308, 
        0.569073793176358,0.245334183573505)
beta3=c(-0.0520122836038581,1.46894946616663,-0.451371801687259, 
         0.0717711452721233,-0.283428626105888,0.177078833312862)
         
piR=1.080748 # Mean of the estimates of the intensity parameter of the 
             # Poisson process
N1<-rpois(1,piR*T)  # Left-side process of the original  T=100; see RTr
U1<-runif(N1,-T,0)
Ar=Tr[runif(N1,1,245),][,2:7]%*%(beta2-beta3)
Y1=Ar^2+2*Tr[runif(N1,1,245),][,1]*Ar

N2<-rpois(1,piR*T)  # Right-side process of the original
U2<-runif(N2,0,T)
Br=Tr[runif(N2,1,245),][,2:7]%*%(beta2-beta3)
Y2=Br^2-2*Tr[runif(N2,1,245),][,1]*Br

t<-seq(-T,T,by=T/1000)
y<-sapply(t,function(x)  sum((U1>x)*Y1)*(x<0)+sum((U2<x)*Y2)*(x>=0))
return(t[which.min(y)])  # Minimizer
}
#####################################################################
RTr<-function(T,Tr){
m=10000     #   Number of replications 
threshold<-rep(0,m)
for (i in 1:m){
threshold[i]<-CPPMr(T,Tr)
}
return(threshold)
}
#####################################################################

rr=RTr(100,Tr)
plot(density(rr),xlab="(a)",main="",xlim=c(-40,40))
round(quantile(rr,c(0.025,0.975))/250+r,2) # Rounded to 2 decimal places
hist(rr,50,fre=F,main="",xlab="(a)",xlim=c(-40,40))

#####################################################################
RTR<-function(T,TR){
m=10000     #   Number of replications
threshold<-rep(0,m)
for (i in 1:m){
threshold[i]<-CPPMR(T,TR)
}
return(threshold)
}
#####################################################################
RR=RTR(100,TR)
plot(density(RR),xlim=c(-70,70),main="",xlab="(b)")
round(quantile(RR,c(0.025,0.975))/250+R,2) # Rounded to 2 decimal places
hist(RR,50,fre=F,main="",xlab="(b)",xlim=c(-50,60))





